/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.debug.Upvalue;
import org.squiddev.cobalt.function.LuaClosure;

public final class LegacyEnv {
    private LegacyEnv() {
    }

    private static int findEnv(Prototype prototype) {
        for (int i = 0; i < prototype.upvalues(); ++i) {
            if (!Objects.equals(prototype.getUpvalueName(i), Constants.ENV)) continue;
            return i;
        }
        return -1;
    }

    public static @Nullable LuaTable getEnv(LuaClosure closure) {
        LuaTable t;
        LuaValue luaValue;
        int index = LegacyEnv.findEnv(closure.getPrototype());
        return index >= 0 && (luaValue = closure.getUpvalue(index).getValue()) instanceof LuaTable ? (t = (LuaTable)luaValue) : null;
    }

    public static @Nullable LuaTable getEnv(LuaValue value) {
        LuaTable luaTable;
        if (value instanceof LuaClosure) {
            LuaClosure c = (LuaClosure)value;
            luaTable = LegacyEnv.getEnv(c);
        } else {
            luaTable = null;
        }
        return luaTable;
    }

    public static void setEnv(LuaClosure closure, LuaTable env) {
        int index = LegacyEnv.findEnv(closure.getPrototype());
        if (index >= 0) {
            closure.setUpvalue(index, new Upvalue(env));
        }
    }

    public static boolean setEnv(LuaValue value, LuaTable env) {
        if (!(value instanceof LuaClosure)) {
            return false;
        }
        LuaClosure c = (LuaClosure)value;
        LegacyEnv.setEnv(c, env);
        return true;
    }
}

